/* -LICENSE-START-
 ** Copyright (c) 2010 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 ** 
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 ** 
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
//
//  BMDOpenGLOutput.h
//  OpenGLOutput
//

#ifndef __BMDOpenGLOutput_h__
#define __BMDOpenGLOutput_h__

#include <windows.h>
#include <process.h>
#include <tchar.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "GLExtensions.h"

#include <objbase.h>
#include <comutil.h>
#include "DeckLinkAPI_h.h"

#include "GLScene.h"

class RenderDelegate;

class BMDOpenGLOutput
{
	
private:
	RenderDelegate*		pRenderDelegate;
	HWND				hGLWnd;
	HDC					hGLDC;
	HGLRC				hGLRC;
	HGLRC				hOldGLRC;
	GLScene*			pGLScene;
	GLenum				glStatus;
	GLuint				idFrameBuf, idColorBuf, idDepthBuf;
	CRITICAL_SECTION	pMutex;	

	// DeckLink
	unsigned __int32			uiFrameWidth;
	unsigned __int32			uiFrameHeight;
	
	IDeckLink*					pDL;
	IDeckLinkOutput*			pDLOutput;
	
	BMDTimeValue				frameDuration;
	BMDTimeScale				frameTimescale;
	unsigned __int32			uiFPS;
	unsigned __int32			uiTotalFrames;

	void SetPreroll();

public:
	BMDOpenGLOutput();
	~BMDOpenGLOutput();

	bool InitDeckLink();
	bool InitGUI(IDeckLinkScreenPreviewCallback *previewCallback);
	bool InitOpenGL();

	bool Start();
	bool Stop();

	void RenderToDevice(IDeckLinkVideoFrame* pDLVideoFrame);
};

////////////////////////////////////////////
// Render Delegate Class
////////////////////////////////////////////

class RenderDelegate : public IDeckLinkVideoOutputCallback
{
private:
	ULONG				m_refCount;
	BMDOpenGLOutput*	m_pOwner;
	
	~RenderDelegate();

public:
	RenderDelegate (BMDOpenGLOutput* pOwner);
	
	// IUnknown
	virtual HRESULT	STDMETHODCALLTYPE	QueryInterface (REFIID iid, LPVOID *ppv);
	virtual ULONG	STDMETHODCALLTYPE	AddRef ();
	virtual ULONG	STDMETHODCALLTYPE	Release ();
	
	// IDeckLinkVideoOutputCallback
	virtual HRESULT	STDMETHODCALLTYPE	ScheduledFrameCompleted (IDeckLinkVideoFrame* completedFrame, BMDOutputFrameCompletionResult result);
	virtual HRESULT	STDMETHODCALLTYPE	ScheduledPlaybackHasStopped ();
};

#endif      // __BMDOpenGLOutput_h__
